unit Wntisam2;
{$IFDEF VER90}
{$H-}
{$ENDIF}

interface
uses WinTypes, Classes, Graphics, Forms;
{$I DEFINE.PAS}
function Erzeuge_EditorForm(aParent: TForm;
                            const FormIdent: string;
                            RecList: TStringList;
                            Label_Neben_Input: Boolean;
                            InputLen_Fest: Boolean;
                            LFont, EFont: TFont;
                            Sprache: Integer): TForm;

implementation

Uses WinProcs, SysUtils, Controls, ExtCtrls, Proxies,
     Db, WntIsam4, StdCtrls, Buttons,
     {$IFDEF NEWINPUTS}
     NumCtrl, DateEdit,
     {$ENDIF}
     IsamTabl, IsamExpt;

function Erzeuge_EditorForm(aParent: TForm;
                            const FormIdent: string;
                            RecList: TStringList;
                            Label_Neben_Input: Boolean;
                            InputLen_Fest: Boolean;
                            LFont, EFont: TFont;
                            Sprache: Integer): TForm;
var
  Exp      : TIsamMainForm;
  BtnPos   : TPoint;
  Method,KeyMethod: TMethod;
  MP,UP,UP1,UP2,UP3: TPanel;
  SP       : TSpeedButton;
  Tbl      : TIsamTable;
  dx,W,i,Ty,G : Integer;
  xDecimals : Integer;
  SLab     : TLabel;
  {$IFDEF NEWINPUTS}
  SInp     : TStrEdit;
  DInp     : TDateEdit;
  NInp     : TNumEdit;
  {$ELSE}
  SInp     : TEdit;
  PInp     : TEdit;
  NInp     : TEdit;
  {$ENDIF}
  MInp     : TMemo;
  RInp     : TRadioGroup;
  Tm       : TTimer;
  FieldName,FeldName,SStr,AStr,MStr: String;
  Len,Arr1,Arr2,A    : Integer;
  FieldDataType      : TFieldType;
begin
  Exp:= TIsamMainForm(aParent);
  {$IFDEF VER90}
  Result := TForm.Create(nil);
  Proxies.CreateSubClass(Result, 'T' + FormIdent, TForm);
  {$ELSE}
  Result := TProxyForm.CreateAs('T' + FormIdent);
  {$ENDIF}
  with Result do begin
    BorderStyle := bsDialog;
    Left:= 100;
    Top:= 101;
    Width := 400;
    Height := 282;
    Position := poScreenCenter;
    Name := FormIdent;
    Caption := FormIdent;
    KeyPreview:= True;
    AutoScroll  := True;
   {$IFDEF VER90}
    Method.Code:= CreateSubClassMethod(Result,'FormCreate');
   {$ELSE}
    Method.Code := TProxyForm(Result).CreateMethod('FormCreate');
   {$ENDIF}
    Method.Data := Result;
    OnCreate    := TNotifyEvent(Method);
   {$IFDEF VER90}
    Method.Code:= CreateSubClassMethod(Result,'FormDestroy');
   {$ELSE}
    Method.Code := TProxyForm(Result).CreateMethod('FormDestroy');
   {$ENDIF}
    Method.Data := Result;
    OnDestroy   := TNotifyEvent(Method);
   {$IFDEF VER90}
    KeyMethod.Code:= CreateSubClassMethod(Result,'FormKeyPress');
   {$ELSE}
    KeyMethod.Code:= TProxyForm(Result).CreateMethod('FormKeyPress');
   {$ENDIF}
    KeyMethod.Data:= Result;
    OnKeyPress:= TKeyPressEvent(KeyMethod);
    with Font do begin
      Color := clBlack;
      Height:= -11;
      Name := 'Arial';
      Size := 8;
      Style:= [fsBold];
    end;

    MP:= TPanel.Create(Result);
    with MP do begin
      Parent := Result;
      Name := 'Panel1';
      Align := alTop;
      ShowHint:= True;
      Caption:= '';
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 10;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'Back'
      else Hint := 'Zurck';
      Name := 'RueckBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_RUECK');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'RueckBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('RueckBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 35;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'forward'
      else Hint := 'Vorwrts';
      Name := 'VorBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_VOR');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'VorBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('VorBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 60;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'Search'
      else Hint := 'Suchen';
      Name := 'SuchBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_SUCH');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'SuchBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('SuchBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 85;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'Sort order'
      else Hint := 'Sortierordnung';
      Name := 'KeyBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_KEY');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'KeyBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('KeyBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 110;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'clear'
      else Hint := 'Leeren';
      Name := 'NeuBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_NEU');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'NeuBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('NeuBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 135;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'save new record'
      else Hint := 'Anlegen';
      Name := 'AnlegBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_ANLEGEN');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'AnlegBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('AnlegBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 160;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'save changed record'
      else Hint := 'ndern';
      Name := 'AendernBttn';
      if Exp.NeuerAendernBttn then begin
        Glyph.Handle:= LoadBitmap(HInstance,'IS_CHANGE');
        NumGlyphs:= 2;
      end
      else begin
        Glyph.Handle:= LoadBitmap(HInstance,'IS_AENDERN');
        NumGlyphs:= 1;
      end;
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'AendernBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('AendernBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 185;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'delete record'
      else Hint := 'Lschen';
      Name := 'LoeschBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_LOESCHEN');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'LoeschBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('LoeschBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 210;
      Top := 8;
      Width := 25;
      Height := 25;
      NumGlyphs:= 2;
      Hint := 'Drucken';
      Name := 'DruckBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_DRUCK');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'DruckBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('DruckBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 240;
      Top := 8;
      Width := 25;
      Height := 25;
      Hint := 'Ok';
      Name := 'OkBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_OK');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'OkBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('OkBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    Sp:= TSpeedButton.Create(Result);
    with SP do begin
      Parent:= MP;
      Left:= 358;
      Top := 8;
      Width := 25;
      Height := 25;
      if Sprache = 1 then Hint:= 'End'
      else Hint := 'Ende';
      Name := 'AbbruchBttn';
      Glyph.Handle:= LoadBitmap(HInstance,'IS_ENDE');
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,'AbbruchBttnClick');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod('AbbruchBttnClick');
     {$ENDIF}
      Method.Data := Result;
      Sp.OnClick := TNotifyEvent(Method);
    end;

    UP:= TPanel.Create(Result);
    with UP do begin
      Parent := Result;
      Name := 'Panel2';
      Align := alBottom;
      BevelInner:= bvLowered;
      Height:= 27;
      ShowHint:= False;
      Caption:= '';
    end;

    UP1:= TPanel.Create(Result);
    With UP1 do begin
      Parent:= UP;
      Left  := 308;
      Top   := 2;
      Width := 108;
      Height:= 23;
      Align := alRight;
      BevelOuter := bvLowered;
      Font.Color := clBlack;
      Font.Height := -11;
      Font.Name := 'Arial';
      Font.Style := [];
      Name:= 'ZeitPanel';
      Caption:= '';
    end;

    UP3:= TPanel.Create(Result);
    with UP3 do begin
      Parent:= UP;
      Left  := 2;
      Top   := 2;
      Width := 186;
      Height:= 23;
      Align := alClient;
      ShowHint:= True;
      BevelInner := bvLowered;
      BevelOuter := bvNone;
      Font.Color := clBlack;
      Font.Height := -11;
      Font.Name   := 'Arial';
      Font.Style  := [];
      Name:= 'HintPanel';
      Caption:= '';
    end;

    Tm:= TTimer.Create(Result);
    With Tm do begin
      Interval:= 1000;
      Name:= FormIdent+'Timer';
     {$IFDEF VER90}
      Method.Code:= CreateSubClassMethod(Result,FormIdent+'TimerTimer');
     {$ELSE}
      Method.Code := TProxyForm(Result).CreateMethod(FormIdent+'TimerTimer');
     {$ENDIF}
      Method.Data := Result;
      Tm.OnTimer := TNotifyEvent(Method);
    end;

    Tbl:= TIsamTable.Create(Result);
    with Tbl do begin
      Name:= FormIdent+'TABLE';
      TableName   := '';
    end;

    if RecList.Count > 0 then begin
      Ty:= 52;
      For i:= 0 to RecList.Count - 1 do begin
        SStr:= RecList[i];
        if (Pos(':',SStr) > 0) and (Pos('DUMMY',UpperCase(SStr)) = 0)
        and (Pos('IGNORE',Uppercase(SStr)) = 0) then begin
          G:= GetFieldTypEditor(SStr,FeldName,FieldDataType,Len,Arr1,Arr2,xDecimals);
          FieldName:= FeldName;
          if Label_Neben_Input = False then Inc(Ty,18);
          if InputLen_Fest then W:= 130 else W:= 8 * (Len - 1);
          if W < 30 then W:= 30;
          if W > 255 then W:= 255;
          For a:= Arr1 to Arr2 do begin
            if Arr1 <> Arr2 then begin
              Str(A,AStr);
              FieldName:= FeldName+AStr;
            end;
            {$IFDEF NEWINPUTS}
            Case G of
              1: begin
                   DInp:= TDateEdit.Create(Result);
                   with DInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := 80;
                     Height := 21;
                     Cursor := crIBeam;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     if FieldDataType = ftTime then begin
                       MaxLength:= 5;
                     end
                     else begin
                       MaxLength:= 10;
                     end;
                   end;
                 end;
              2: begin
                   NInp:= TNumEdit.Create(Result);
                   with NInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := W;
                     Height := 21;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     NumericType:= ntGeneral;
                     Case FieldDataType of
                       ftInteger,
                       ftBytes   : begin
                                     Decimals:= 0;
                                     Masks.PositiveMask:= '#0';
                                   end;
                       ftSmallInt: begin
                                     Decimals:= 0;
                                     Masks.PositiveMask:= '#0';
                                   end;
                       ftWord    : begin
                                     Decimals:= 0;
                                     Masks.PositiveMask:= '#0';
                                   end;
                       else begin
                         Decimals:= xDecimals;
                         if xDecimals < 2 then MStr:= '0.0'
                         else begin
                           MStr:= '0.#';
                           For dx:= 2 to xDecimals do MStr:= MStr + '0';
                         end;
                         Masks.PositiveMask:= MStr;
                       end;
                     end;
                   end;
                 end;
              3: begin
                   MInp:= TMemo.Create(Result);
                   with MInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := 130;
                     Height := 89;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := Efont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     Scrollbars:= ssBoth;
                     TabStop := True;
                   end;
                 end;
              4: begin
                   RInp:= TRadioGroup.Create(Result);
                   with RInp do begin
                     Name:= FieldName+'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := 133;
                     Height := 37;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := Efont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     Columns:= 2;
                     Caption:= '';
                     if Sprache = 1 then begin
                       Items.Add('No');
                       Items.Add('Yes');
                     end
                     else begin
                       Items.Add('Nein');
                       Items.Add('Ja');
                     end;
                     ItemIndex:= -1;
                   end;
                 end;
              else begin
                   SInp:= TStrEdit.Create(Result);
                   with SInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := W;
                     Height := 21;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     if Pos('{UPCASE}',Uppercase(SStr)) > 0 then CharCase:= ecUppercase;
                     MaxLength:= Len;
                     TabStop := True;
                   end;
                 end;
            end;
            {$ELSE}
            Case G of
              1: begin
                   PInp:= TEdit.Create(Result);
                   with PInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := W;
                     Height := 21;
                     Cursor := crIBeam;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     if FieldDataType = ftTime then begin
                       MaxLength:= 5;
                     end
                     else begin
                       MaxLength:= 10;
                     end;
                   end;
                 end;
              2: begin
                   SInp:= TEdit.Create(Result);
                   with SInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := W;
                     Height := 21;
                     Cursor := crIBeam;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                   end;
                 end;
              3: begin
                   MInp:= TMemo.Create(Result);
                   with MInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := 130;
                     Height := 89;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := Efont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     ScrollBars:= ssBoth;
                     TabStop := True;
                   end;
                 end;
              4: begin
                   RInp:= TRadioGroup.Create(Result);
                   with RInp do begin
                     Name:= FieldName+'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := 133;
                     Height := 37;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := Efont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     Columns:= 2;
                     Caption:= '';
                     if Sprache = 1 then begin
                       Items.Add('No');
                       Items.Add('Yes');
                     end
                     else begin
                       Items.Add('Nein');
                       Items.Add('Ja');
                     end;
                     ItemIndex:= -1;
                   end;
                 end;
              else begin
                   SInp:= TEdit.Create(Result);
                   with SInp do begin
                     Name:= FieldName + 'Input';
                     Parent:= Result;
                     if Label_Neben_Input then Left:= 100 else Left:= 20;
                     Top   := Ty;
                     Width := W;
                     Height := 21;
                     Cursor := crIBeam;
                     Font.Color := EFont.Color;
                     Font.Height := EFont.Height;
                     Font.Name := EFont.Name;
                     Font.Style := EFont.Style;
                     ParentColor := False;
                     TabStop := True;
                     if Pos('{UPCASE}',Uppercase(SStr)) > 0 then CharCase:= ecUppercase;
                     MaxLength:= Len;
                   end;
                 end;
             end;
            {$ENDIF}
            if Label_Neben_Input = False then Dec(Ty,18);
            SLab:= TLabel.Create(Result);
            With SLab do begin
              Name:= FieldName+'Label';
              Parent:= Result;
              Caption:= FieldName;
              Left:= 20;
              Top:= Ty + 2;
              Font.Color := LFont.Color;
              Font.Height := LFont.Height;
              Font.Name := LFont.Name;
              Font.Style := LFont.Style;
            end;
            Ty:= Ty+24;
            if Label_Neben_Input = False then Inc(Ty,20);
            if G = 3 then Ty:= Ty + 68;
            if G = 4 then Ty:= Ty + 20;
          end; {for arr1 to arr2}
        end;
      end;
    end;
  end;
end;

end.
